import argparse
import shutil
import os

def parse_args():
    descript = 'Pytorch Implementation, FS-PTAL'
    parser = argparse.ArgumentParser(description=descript)
    parser.add_argument('--config', type=str, default='config/thumos_i3d_train.yaml')
    parser.add_argument('--debug', action='store_true')

    return parser.parse_args()


def init_args(args):
    if not os.path.exists(args['dataset']['model_path']):
        os.makedirs(args['dataset']['model_path'])

    if os.path.exists(args['dataset']['log_path']):
        shutil.rmtree(args['dataset']['log_path'])
    if not os.path.exists(args['dataset']['log_path']):
        os.makedirs(args['dataset']['log_path'])

    if not os.path.exists(args['dataset']['output_path']):
        os.makedirs(args['dataset']['output_path'])

    return args
